# @tabler/core

## 1.4.0

### Minor Changes

- 9951fe9: Enhance button and hover animations
- a200d30: Improve breadcrumb styles
- 49ab9ea: Add new Tabler Illustrations

### Patch Changes

- 6c4dd36: Update class names from `*-left`, `*-right` to `*-start`, `*-end`
- 6fec73a: Fix relative line heights in buttons
- db6200a: Remove `license_key` option from HugeRTE init object
- e96f055: Add different favicon to development environment
- 6c38a48: Update Bootstrap to v5.3.7
- 2a12f72: Update CSS calculations to use `calc()`
- 666a296: Fix list group item hoverable only with `.list-group-hoverable` class
- cfd4cb6: Fix `.pagination-link` hover styles to non-active items

## 1.3.2

### Patch Changes

- 446c34e: Fix README file in core package

## 1.3.1

### Patch Changes

- a7f73d7: Fix README file in core package

## 1.3.0

### Minor Changes

- a1af801: Add FullCalendar integration
- b9d434d: Add new charts to dashboard pages
- 79bd867: Add new form layout page

### Patch Changes

- cac5d92: Update illustrations to v1.7
- f94b153: Add SRI hashes to scripts and styles
- c127d65: Fix colour picker preview page not displaying correctly
- b6e9b18: Update icons to v3.31.0
- 8850f61: Enhance pagination component with new styles
- 9910dd0: Add "text features" menu item
- 638f36c: Refactor SCSS variable names for shadows
- 0d501e9: Correct `aria-label` of app menu link
- 3a02ef9: Fix some marketing site rows overflowing on mobile
- fd0fd47: Improve card footer layout and enhance entry display format in invoices
- 74e5d26: Fix color badge in navbar menu
- 72a1d67: Add clipboard functionality to Tabler documentation
- bb617b8: Fix colour swatches on small screens
- d73d78e: Add missing `tw` entry in `flags.json`
- 19a3d20: Delete missing demo RTL style
- b5e2f54: Enhance dropdown components for better accessibility
- a41c956: Remove unnecessary `!important` from body padding
- e675389: Fix missing border-radius to `.card-header-tabs`
- 9007e73: Fix FAQ accordion structure

## 1.2.0

### Minor Changes

- c59bc9d: Add gradient background utilities
- f9e4da2: Add new apps card with brand icons in navbar
- 92a3afe: Replaced TinyMCE with HugeRTE to address license violation
- 199f39a: Update Bootstrap to version 5.3.5
- 9bbcb99: Add theme settings wizard
- b17b488: Add steps light colors
- 215eaa4: Add Turbo library integration

### Patch Changes

- aea3b0a: Rollback accordion component structure
- 3fc7b84: Add space between page numbers in pagination
- 2f8a372: Add Bootstrap components to Tabler JS
- 9fceadd: Fix tooltip colors in vector maps
- 44250db: Update avatar size variable to support list size configuration
- be1f3d1: Fix broken shape in South Korea flag
- c20d076: Refactor `border-radius` in components to use CSS variables
- 042e50f: Update disabled color variables in navbars
- 473fa38: Apply border radius to `tom-select` on focus
- 8646192: Add avatars page with various demos of avatars
- 922bb03: Minor spelling and grammar improvements to emails docs
- 44250db: Update avatar size variable to support list size configuration
- ddcd3a7: Refactor SCSS for alerts and close button styles
- e3d68d6: Fix `autosize` and `input mask` plugins to use window scope
- 4846828: Fix scrollbar color mixin to use body color variable
- 6b6617a: Improve README
- 94bea00: Make scrollbar track transparent
- e14e492: Fix scrollbar jumps when content is higher than screen
- 6d6d1bd: Add responsive font size for form controls on mobile devices
- 6c566cf: Add new advanced table example

## 1.1.1

### Patch Changes

- f29c911: Fix Documentation structure

## 1.1.0

### Minor Changes

- a2640e2: Add Playwright configuration and visual regression tests
- d3ae77c: Enable `scrollSpy` in `countup` module
- bd3d959: Refactor SCSS files to replace divide function with calc
- cb278c7: Add Segmented Control component
- b47725d: Add new text features page with mentions: user, color and app.
- b4b4d1a: Add Scroll Spy page
- 9cd5327: Update border radius variables for consistency across components
- 4376968: Add Signature Pad feature and signatures page
- f95f250: Update color utility classes and replace background colors in pricing table
- eaa7f81: Refactored the project into a monorepo, removed Gulp, and introduced a new, more efficient build process.
- ea14462: Add documentation for segmented control component
- 1edaff4: Add new payment provider (Troy)
- edbaa1e: Add selectable table functionality with active background color
- 378fba8: Refactor badge styles, remove Bootstrap styles
- f3c409f: Refactor alert component styles and markup, remove Bootstrap styles
- c240b5a: Refactor accordion component styles and markup, remove Bootstrap styles

### Patch Changes

- 687267d: Fix overflow of `label` in a `floating-input`
- 06b1dec: Fix size of `apexcharts` tooltip marker
- afd0700: Fix apexcharts heatmap example in docs
- 78383ef: Fix negative margins in `.navbar-bordered` variant
- 11f4487: Use the full license agreement for illustrations in docs
- b28ce9f: Fix vertical alignment in single page and error layouts
- 24b944c: Fix `.avatar-upload` double borders
- ca4ba14: Fixes navbar styles with new hover effects and color variables

## 1.0.0 - 2025-01-28

### Minor Changes

- c276a8b: Add new `Tag` component
- d380224: Add customizable Star Ratings component using `star-rating.js` library
- 47cd6c1: Add `flags.html` page with list of all flags
- be67ab6: Update CSS class from `text-muted` to `text-secondary` for better Bootstrap compatibility
- 080c746: Adding `alerts.html` page with example of alerts.
- b381273: Change primary color value to new Tabler branding
- 75619dd: Unify dark mode with latest Bootstrap API and improve dark mode elements
- cc82dbf: New Chat component
- 5a03643: Adjusting form element sizes for enhanced mobile devices compatibility
- be14607: Add new color picker component using `coloris.js` library
- d046570: Update Tabler Icons to version 2.23 with 18 new icons added
- 5488c50: New page with payment providers: `payment-providers.html`
- 5488c50: Add support for new payment providers: 2c2p, Adyen, Affirm, Alipay Plus, Allegro Pay, Amazon Pay, Apple Pay, Autopay, Binance USD, Bkash, Cash App, Chime, EasyPaisa, Ethereum, Google Pay, HubSpot, iDeal, Litecoin, Mercado Pago, MetaMask, MoneyGram, OpenSea, Payconiq, Payka, Payline, PayPo, Paysafe, Poli,
  Revolut Pay, Samsung Pay, Shop Pay, Solana, Spingo, Stax, Tether, True USD, Venmo, WeChat Pay, Wise, Zelle

### Patch Changes

- 293d0a4: Change Twitter to X brand
- fd0935a: Updated link to icons documentation
- 1cf27dc: Dependencies update
- 041f4e4: Order menu items alphabetically
- 20cad01: Automatically retrieve and display the changelog from the CHANGELOG.md file.
- 34f3efc: Initialize Visual Studio Code config
- 7ba7717: Make horizontal rule direction aware
- 063ef58: Update Tabler Illustrations to v1.5
- 5e2c975: Update Tabler Icons to v3.29.0
- 9d5f7ca: Remove unused dependencies from `package.json`
- be69fd6: Replace Jekyll with Eleventy
- 2f5fad6: Dependencies update
- dfd7c88: Update TinyMCE to v7.0
- 056df18: Fix text color in dark version of navbar
- 17327dc: Remove invalid `z-index` setting for dropdowns
- 4ff077a: Update Tabler Icons to version 2.21 with 18 new icons added
- 867c8dd: Update Tabler Emails to v2.0
- d8605f2: Init changelog script
- 89c6234: Adding Two-Step Verification Pages
- f6e885b: Replace `.page-center` with `.my-auto` in single page layouts
- 7aa216f: Add border-opacity variable for improved color utility
- 88eb413: Fix icon display issues in the Star Ratings component
- 78392b6: Fix `color` of disabled `dropdown-item` in Navbar component
- 4deb8f4: Bump pnpm/action-setup from 2 to 3
- 9015472: Add social icons plugin
- 7fe30a1: `Dockerfile` fix
- e53942f: Update Jekyll to version 4.3.4
- 72f868b: Update Tabler Icons to version 2.20 with 37 new icons added
- e0443c0: Add Tabler Illustrations
- 5cca710: Update illustrations and enhance SVG handling in HTML
- 3a4f10f: Fix ids of custom size star ratings
- 7896562: Unify size of avatar, flag and payment components
- 1587905: Update icons to v2.42.0
- d9e00b2: Update Bootstrap to v5.3.0
- bc1d1a3: Set `font-size` of an `i` element with `icon` class in a `button` element
- 0195f9b: Dependencies update
- a5bf5d3: Fix icons in `form-elements.html`
- 736410c: Update Tabler Icons to v3.28.1
- 3f516ea: Fix `rgba` color values in `_variables.scss`
- e91884e: Fix description of alerts with a description
- 90cc744: Fix colors of disabled `.ts-control`
- 1801e41: Center content on error and single page layouts
- 45c83ac: Resolve map page issues
- faee63c: Improve base font family loading
- 5e7e0dd: Introduce Docker Compose Config to build and run Ttabler locally
- c293a66: Fix `@charset` CSS declaration in bundle.
- cb4a681: Update `_navbar.scss` with disabled dropdown menu items color
- af41fb3: Update Tabler Icons to v3.17.0
- 6cbe888: Update `@tabler/icons` to v3.0
- 0e4bf5f: Refactor data structure by converting YAML files to JSON
- 82cf257: Increase `z-index` of `ts-dropdown` to prevent overlapping by buttons
- 4b4b4f6: Adding punctuation to `SECURITY.md`
- a0a2d52: Fix form controls bugs in dark mode
- f45b697: Fix padding in code blocks
- 4de166d: Unified Box Shadows with Bootstrap Compatibility
- 87bf2f5: Remove duplicated setting of color in `th` element
- 5dc45aa: Fix layout of search results for small and medium screens
- 4ae0358: Remove `text-decoration` on hovering `a` element with class having `icon` class
- e798eb6: Fix small typo in tables docs
- 1c1d0c9: Improve documentation for alerts
- 371ef84: Bump `pnpm/action-setup` from 3 to 4
- 8421fc2: Update dependencies
- 0625f5f: Update Tabler Icons to version 2.22 with 18 new icons added
- ba65fc3: Update devDependencies
- a43ded4: Add All Contributions package to project for easy contribution tracking
- 2f622c9: Set value of `$font-family-monospace` as default
- 2c7c448: Refactor Dockerfile and package.json
- 5ec7f05: Resolved light dropdown issue on dark theme
- b0b07b9: Enhance documentation
- 0f129b1: Update Tabler Icons to version 2.19 with 18 new icons added
- 507df7b: Fix cells with inline icons
- 0e5b44a: Fix `color` of disabled `nav-link` in `nav-bordered`
- 65c1300: Fix the `z-index` value of the `nav-tab` inside `card-tab` #1933
- 8552a46: Switch from `npm` to `pnpm` for faster package installation
- 4a9e40d: Increase contrast of active `dropdown-item` in vertical layout
- 17ebdf4: Update documentation for Tabler components
- 4c88481: Add variable to configure `avatar-list` spacing
- df46ee7: Do not display empty `fieldset` element
- 875cafa: Refactor SCSS variables to use `color.adjust` for improved color manipulation
- eb28546: Add Tabler Illustrations
- 650d84c: Update required Node.js version to 18 and add `.nvmrc` file
- fb659d4: Fix table default background color
- f77c712: Avoid SCSS color dependency on `:focus`
- 71c68ce: Update changelog configuration and release scripts
- 34d124d: Update Tabler Icons to v3.26.0
- 4cd9215: Updated Tabler Icons to v3.24.0
- 7bb947b: Update Tabler Icons to version 2.18 with 18 new icons added
- c75cf55: Update Node.js engine requirement to allow versions >=20
- 1c34e8e: Update Tabler Icons to v3.14.0
- 289dd3b: Add Prettier to project for consistent code formatting
- f83e36c: Upgrade Node.js from version 18 to version 20 for improved performance, security, and feature updates.
- b885852: Update Tabler Icons to version 2.25 with 48 new icons added
- 53a5117: Fix responsiveness issue in Settings menu
- 38504e5: Added 3 new payments from Nepal: Esewa, FonePay, Khalti and Imepay
- 35ee14d: Add new Filled section to Icons page
- d32f242: Update `bootstrap` to v5.3.1
- d82f94e: Update package dependencies to latest versions
- 54c5ad0: Fix link to webfont version of Tabler Icons
- 94b83d4: Add support for changeset tool for more efficient and organized code changes
- c51ff28: Fix colors in date range datepicker

## `1.0.0-beta24` - 2025-01-11

- Enhanced documentation.
- Updated illustrations and improved SVG handling in HTML.
- Updated copyright year in LICENSE file to 2025.
- Added marketing pages plugin.

## `1.0.0-beta23` - 2025-01-07

- Documentation improvements.
- Added countup functionality and updated documentation example.
- Do not display empty `<fieldset>`.
- Set font-size of webfont icon inside a button.
- Ordered menu items alphabetically.
- Marked value of `$font-family-monospace` as `!default`.
- Fixed unpkg links to static-files icons.
- Fixed description of alerts with a description.
- Fixed layout of search results for small and medium screens.
- Removed invalid z-index setting for dropdown.
- Fixed IDs of custom size star ratings.
- Removed text-decoration on hover for elements with child icons.
- Fixed link to webfont icons.
- Updated color reference links in UI component documentation.
- Fixed typo in browser support documentation summary.
- Enhanced Figma plugin documentation with detailed usage instructions.
- Added documentation for Tabler Illustrations and updated index with a link.
- Enhanced documentation for various UI and icon sections.
- Added new documentation files for icons and UI components; restructured existing files.
- Updated documentation structure and content for icons and UI components.
- Removed outdated `menu.json` and added `index.mdx` files for UI documentation structure.
- General docs update.
- Increased contrast of active dropdown-item in vertical layout.
- Removed duplicated color setting in table headers.
- Increased `z-index` of `ts-dropdown`.
- Added social icons plugin.
- Described variables for datagrid in docs.
- Fixed multiple documentation issues.
- Removed unused config from the code.
- Fixed links to Tabler Icons.
- Updated dark image.
- Updated screenshot.
- Fixed icon issues.
- Fixed URL in documentation.

## `1.0.0-beta22` - 2025-01-02

- Fixed `@charset` CSS declaration in bundle.
- Fixed cells with inline icons.
- Fixed padding in code blocks.
- Fixed colors in date range datepicker.
- Fixed icon display issues in the Star Ratings component.
- Fixed `z-index` value of the `nav-tab` inside `card-tab`.
- Fixed wrong gray colors.
- Fixed incorrect CDN URL in `webfont.mdx`.
- Ensured border color works in dark mode.
- Replaced `.page-center` with `.my-auto` in single-page layouts.
- Updated Tabler Emails to v2.0.
- Updated Tabler Icons to v3.26.0.
- Updated docs structure.
- Updated `download.mdx`.
- Updated Node.js to version 20.
- Improved base font family.
- Made horizontal rule direction-aware.
- Added new payment providers.
- Read changelog from `CHANGELOG.md` file.
- Initialized VS Code configuration.

## `1.0.0-beta21` - 2024-09-8

- Updated dependencies.
- Updated Tabler Icons to v3.14.0 and the import script.
- Fixed invisible scrollbar in dark mode when navigating the preview.
- Styled `btn-close` specifically for `.modal-header`.
- Added proper borders to the ribbon start class.
- Changed brand color.
- Included `docs` in the `npm` package.
- Added Tabler Illustrations.
- Fixed use of the secondary color in specific form elements.
- Introduced Docker Compose Config for local Tabler builds.
- Allowed usage of `tinymce` v7.x as a peer dependency.
- Updated TinyMCE to v7.0.
- Rebranded Twitter to X.
- Replaced undraw illustrations with Tabler Illustrations.
- Added punctuation to `SECURITY.md`.
- Updated `_navbar.scss` to correct disabled dropdown menu item colors.
- Removed unused packages.
- Fixed map pages.
- Resolved issues with toasts in dark mode.
- Fixed alert background prefix.
- Corrected a typo in CHANGELOG.md.
- Fixed radial chart issue.
- Added documentation on running the site locally in Site README.
- Updated colors in `colors.mdx`.
- Fixed dynamic SCSS prefix in mixins.
- Changed `<h1>` to `<div>` in `navbar-logo.html`.
- Resolved vertical centering on error pages.
- Fixed navbar menu issues.
- Added `background-clip: border-box` to `.dropdown-menu` class.
- Replaced `href="#"` with `href="javascript:void(0)"`.
- Fixed disabled CSS class for links.
- Addressed missing variables and minor color adjustments.
- Improved heights, scrolls, and layouts in Docs examples.
- Fixed flags display in preview.

## `1.0.0-beta20` - 2023-08-24

- Update `bootstrap` to v5.3.1
- Add new `Chat` component
- Add new `Tag` component
- Add customizable Star Ratings component using `star-rating.js` library
- Add new color picker component using `coloris.js` library
- Add `alerts.html` page with example of alerts.
- Add `flags.html` page with list of all flags
- Add Two-Step Verification Pages
- Add variable to configure `avatar-list` spacing
- Unify dark mode with latest Bootstrap API and improve dark mode elements
- Unify Box Shadows with Bootstrap Compatibility
- Avoid SCSS color dependency on `:focus`
- Update CSS class from `text-muted` to `text-secondary` for better Bootstrap compatibility
- Fix text color in dark version of navbar
- Adjusting form element sizes for enhanced mobile devices compatibility
- Resolved light dropdown issue on dark theme
- Update Tabler Icons to version 2.32 with 48 new icons added
- Fix table default background color
- Fix responsiveness issue in Settings menu
- Update required Node.js version to 18 and add `.nvmrc` file
- Add support for changeset tool for more efficient and organized code changes
- `Dockerfile` fix
- Switch from `npm` to `pnpm` for faster package installation

## `1.0.0-beta19` - 2023-05-15

- Add customizable Star Ratings component using `star-rating.js` library (#1571)
- Add new "Filled" section to Icons page (#1574)
- Fix form controls bugs in dark mode (#1573)
- Fix text color in dark version of navbar (#1569)
- Changelog update

## `1.0.0-beta18` - 2023-05-14

- new page: Cookie banner
- Unify dark mode with latest Bootstrap API and improve dark mode elements (#1561)
- Update Tabler Icons to version 2.18 with 18 new icons added (#1560)
- Switch from `npm` to `pnpm` for faster package installation (#1559)
- Add Prettier to project for consistent code formatting (#1558)
- Update required Node.js version to 18 and add `.nvmrc` file (#1555)
- Add All Contributions package to project for easy contribution tracking (#1556)
- Add support for changeset tool for more efficient and organized code changes (#1553)
- Fix bug where `border-1`, `border-2`, etc don't work (#1526)
- Fix indeterminate input background color (#1536)
- Update Bootstrap to `5.3.0-alpha3` (#1543)
- `tom-select` dark mode styling fixes
- Advanced udage of `tom-select` (#1480)
- Fix Dropdown menu in rtl mode (#801)
- Fix `tom-select` dropdown will be shaded in table-responsive (#1409)
- Remove overflow scroll from body
- Fix avatars overlap transparently (#1464)
- Fix TinyMCE dropdown icon list transparent (#1426)
- Dark mode lite colors improvement
- Fix non full width selects (#1392)

## `1.0.0-beta17` - 2023-01-28

- update `bootstrap` to v5.3.0
- update icons to v2.1.2
- add 72 new brands, browsers logos update
- new `Trial ended` page
- new `Page loader` page
- new `Profile` page
- headings fix
- dropdown background color fix
- fix rgba conversion bug
- fix autofill text color, not matching in dark mode
- update license
- header html5 tags
- add input with appended `<kbd>`
- `bootstrap` import fix
- font improvements
- change `$body-color` to CSS variable
- scrollbars improvements
- move `@tabler/icons` to `dev-dependencies`
- fix #1370: avatar stacked list is not stacked anymore

## `1.0.0-beta16` - 2022-11-12

- new `Photogrid` page
- `Steps` component improvements
- fix #1348: Make job listing responsive for smaller devices
- fix #1357: buttons group not active
- fix #1352: fix deprecation warning
- fix #1180: number input with `form-control-sm` looks weird
- fix #1328: color input should show different color for inner check symbol on white ellipse
- fix #1355 - missing font sizes
- update icons to v1.111.0
- homepage navbar fix
- fix #1262 - `.bg-opacity-xx` class is not functioning properly

## `1.0.0-beta15` - 2022-11-01

- new `badges` page
- `<kbd>` styling
- update icons to v1.109.0
- `tom-select` border fix
- exclude `playgrounds` from build
- update jekyll to v4.3.1
- fix: facebook color update
- navbar aria atributes fixes
- fix #808 - `navbar-menu` and `sidebar-menu` has the same `id`
- fix #1335 - missing color variables usage in `alert` and `btn-ghost-*`
- move border style to CSS variables
- add missing forms
- `btn-actions` fixes
- replace `$text-muted` to css variable

## `1.0.0-beta14` - 2022-10-21

- fix active items in dark mode
- update Jekyll to newest version

## `1.0.0-beta13` - 2022-10-18

- update Bootstrap to 5.2.1, update dependencies
- new `tracking` component
- new radio button version of `form-imagecheck`
- update icons to v1.105.0
- dark mode improvements
- corrects the spelling of New Zealand (#1318)
- remove `$border-color-dark`
- fix #1301 - code snippets in docs look bad in dark mode
- fix #1305 - different default link color for dark mode
- fix popover background in dark mode
- fix button default border color
- fix `form-imagecheck` bg in dark mode
- navbar logo fix
- move card ribbons config to variables
- navbar border fix
- dark mode active fix
- using globalThis instead of window (#1315)
- fix #1210 - lastmod not generated for pages in `sitemap.xml`
- fix card border in dark mode
- fix #895 - background color overwrites background image
- fix #1302 - wrong card header in dark mode
- fix #1303 - wrong color when hovering over `selectgroup` in dark mode
- fix #1308 - bad coloring in table in dark mode
- fix #1273 - datepicker background color broken
- fix `$prefix` hard coded `layout/_dark.scss`
- fix #1275 - remove last border-right on progress bar
- fix #1261 - broken offcanvas bg

## `1.0.0-beta12` - 2022-09-19

- new "Job listing" page
- new "Sign in with cover" page
- new "Logs" page
- new `progressbg` component
- add a lot of CSS variables
- add Dockerfile with alpine base
- add icon pulse/tada/rotate animations
- use `:host` in selectors to support Web Components
- use dark table variant colors in dark mode (#1200)
- update Tabler Icons to v1.96
- change `space-y` component
- headings, shadows and borders unify
- toggle TinyMCE dark mode and skin based on the set Tabler theme
- fix `card-footer` background
- fix headers weight
- fix transparent hover background in pagination
- fix dark mode card text color
- fix `--#{$prefix}card-bg` is undefined
- fix global variable for `.card` and `.btn`
- fix code sample in the customize tabler docs
- fix form elements demo page radio buttons
- replace `gulp-minify` with `gulp-terser`

## `1.0.0-beta11` - 2022-07-05

- new `Dropzone` component
- new `Lightbox` component
- new `TinyMCS` component
- new `Inline Player` component
- new `Pricing table` component
- new `Datagrid` component
- new optgroup form examples
- new settings page
- update Tabler Icons to v1.78
- added popover docs page
- fix: #1125 incorrect chart display in the mobile version
- update Bootstrap to 5.2.0

## `1.0.0-beta10` - 2022-04-29

- new `datatable` component
- update Tabler Icons to v1.67
- fix: #1024 - fix Tom-select in dark mode
- new carousel indicators: dots, vertical, thumbs (#1101)
- replace !important modifier with more specific selectors (#1100)
- new `FAQ` page

## `1.0.0-beta9` - 2022-02-26

- fix: #1061 - list group item colors in light and dark modes
- new `tasks` dashboard
- fix: #1059 - upload button in form element in dark view has problem
- fix: #1052 - card background icon is practically invisible
- remove Inter font and use default font system stack
- fix: #1018 - vector map not working
- fix: #1035 - wrong background color of hovered list group items in dark mode
- dependencies update
- add `font-display: swap;` to improve font loading
- new `Boxed` layout

## `1.0.0-beta8` - 2022-02-05

- update dependencies
- new vector maps demos
- fixes update map on resize
- docs improvement
- replace `badge` with `status-dot` in `navbar-notifications.html`
- map tooltip fixes

## `1.0.0-beta7` - 2022-02-05

- fix: #1019 - project-overview.html link not working
- fix: #1010 - card with bottom tabs has incorrect border radius
- uptime monitor mobile fixes
- navbar dark button fix
- `tabler-icons` link
- autoloading webfonts
- cards fixes, new cards demos
- ruby dependencies update
- RTL stylesheet fixes
- new card action demos

## `1.0.0-beta6` - 2022-01-18

- pricing cards fix
- fix bug `fw-...`, `.fs-...` is missed (#987)
- avatar class fix
- fix bug #903 `litepicker` with date range not having correct border
- page wrapper fix
- fix #900 `is-invalid-lite` class is not working under `was-validated` form class
- update `@tabler/icons` to version 1.48
- fix #960 - Badges not honoring font sizes
- fix #959 - `node-sass` does not properly compile nested media queries
- update package dependencies to newest version

## `1.0.0-beta5` - 2021-12-07

**Tabler has finally lived to see dark mode! 🌝🌚**

- **Dark mode enabled!**
- add more cursors (#947)
- fix #892 - media queries need to be nested when negating
- update `@tabler/icons` to newest version
- move optional dependencies to peerDependencies (#924)
- move deployment to Github Actions (#934)
- table border fixes
- antialiased fix
- update `@tabler/icons` to version 1.42
- change default font to 'Inter'
- colors unify
- add `tom-select` and remove `choices.js`

## `1.0.0-beta4` - 2021-10-24

- upgrade required node.js version to 14
- upgrade Bootstrap to 5.1
- upgrade dependencies
- fix #775 - litepicker not initializing
- fix `nouislider` import in dev

## `1.0.0-beta3` - 2021-05-08

- upgrade Bootstrap to 5.0
- upgrade dependencies
- change `$border-radius-pill` variable
- badge vertical align fix

## `1.0.0-beta2` - 2021-03-29

- update dependencies
- `li` marker fix
- page wrapper, nav fixes
- scripts optimize, remove `capture_once`
- `page-body` fixes
- layout navbar fix
- typography fix
- ribbon fix
- charts label fixes
- charts docs

## `1.0.0-beta` - 2021-02-17

**Initial beta release of Tabler v1.0! Lots more coming soon though 😁**

- update Bootstrap to 5.0.0-beta2
- update other dependencies.
